require( "quest/m2_sunnyside/convout.lua" );
combine_speech_tables();

note_spawn_position = { x = 328, y = 324 };
note_speed = 9;
note_value = 20;
note_info =
{
	{ position = { x = 12, y = 29 }, depth = 29, image = "dollar_hidden1" },	-- 1
	{ position = { x = 380, y = 128 }, depth = 14, image = "dollar_hidden3"},	-- 2
	{ position = { x = 16, y = 177 }, depth = 177, image = "dollar_hidden3"},	-- 3
	{ position = { x = 138, y = 154 }, depth = 154, image = "dollar_hidden2"},	-- 4
	{ position = { x = 280, y = 120 }, depth = 120, image = "dollar_hidden2"},	-- 5
	{ position = { x = 478, y = 196 }, depth = 196, image = "dollar_hidden2"},	-- 6
	{ position = { x = 674, y = 192 }, depth = 192, image = "dollar_hidden1"},	-- 7
	{ position = { x = 79, y = 238 }, depth = 238, image = "dollar_hidden1"},	-- 8
	{ position = { x = 435, y = 272 }, depth = 272, image = "dollar_hidden1"},	-- 9
	{ position = { x = 113, y = 348 }, depth = 348, image = "dollar_hidden2"},	-- 10
	{ position = { x = 590, y = 348 }, depth = 500, image = "dollar_hidden3"},	-- 11
	{ position = { x = 62, y = 403 }, depth = 380, image = "dollar_hidden1"},	-- 12
	{ position = { x = 158, y = 277 }, depth = 314, image = "dollar_hidden3"},	-- 13
	{ position = { x = 458, y = 322 }, depth = 357, image = "dollar_hidden2"},	-- 14
	{ position = { x = 689, y = 333 }, depth = 358, image = "dollar_hidden3"},	-- 15
}

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
	"anim/flo/moneybox",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		if game:GetLastScene() == "m2_intersection" then
			actor:FaceNow(DIR.W);
			actor:JumpToNamedPoint("flo_intersection");
			scene:SetCameraFollowActor(actor);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			game:SetString("map_position", "m2_fitness");
		else -- game:GetLastScene() == "m2_fitness" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("to_fitness");
			scene:SetCameraFollowActor(actor);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
		end;
		
		wait_walkto();
		actor:Face(DIR.S);
		
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		spawn_nav_arrow(to_fitness_spec);
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function look_in_purse_for_money(flo)
	game:SetString("purse_level", "level_two");
	scene:ChainToSubScene("purse");
	wait_subscene();
	raise_hud();
	
	while not hud_raised() do
		delay(1);
	end
	
	if game:Get("found_ten_dollars_in_purse") > 0 then
		run_super_conversation(flo, "conv_give_payment_A");
		
		scene.FLO:WalkTo("flo_moneybox");
		wait_walkto(scene.FLO);
		scene.FLO:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.FLO:ClearFlag(AFLAG.AFLAG_SCALE_BY_Y);
		scene.FLO:PlayAnim("OpenMoneyBox");
		scene.BOX:SetAlpha(0);
		wait_anim(scene.FLO);

		scene:Spawn(wind_spec);
		local lineid = "conv_give_payment_A_4";
		local lineraw = scene:grabstring(lineid);
		scene.GIRL1:SayRaw(lineraw);
		sfx:PlayVox(lineid);
		
		while scene["WIND"] do
			delay(1);
		end
		
		scene.GIRL1:SayRaw("");
		
		scene.FLO:PlayAnim("CloseMoneyBox");
		wait_anim(scene.FLO);

		scene.BOX:SetAlpha(1);
		scene.FLO:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.FLO:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		scene.FLO:PlayAnim("DoStandE");
		scene.FLO:FaceNow(DIR.E);
		scene.FLO:FaceNow(DIR.W);
		
		
		game:Set("girl_sprout_money_on_street", 1);
		
		delay(30);
		
		run_super_conversation(flo, "conv_give_payment_B");
		flo:WalkTo("flo_west");
		wait_walkto();
		flo:Face(DIR.S);
	else
		run_super_conversation(flo, "conv_girls_quit_purse");
	end
end

function sprout_conv(flo)
	flo:SetMode(MODE.CUTSCNE);
	
	if game:Get("first_time_talked_to_sprouts") < 1 then
		game:Set("first_time_talked_to_sprouts", 1);
		run_super_conversation(flo, "conv_girls_intro");
		add_quest("pass_girl_sprouts", false);
		--wait_subscene();
		
		look_in_purse_for_money(flo);
	elseif game:Get("found_ten_dollars_in_purse") < 1 then
		run_super_conversation(flo, "conv_girls_need_pay");
		
		look_in_purse_for_money(flo);
	elseif game:Get("girl_sprout_money_on_street") == 1 then
		run_super_conversation(flo, "conv_need_bills_A");
	else
		local conv_girls_done_choice = game:Get("conv_girls_done_choice");
		local conv_girls_done = ""
		
		if conv_girls_done_choice < 1 then
			conv_girls_done_choice = 1;
		end
		
		if conv_girls_done_choice == 1 then
			conv_girls_done = "conv_girls_done_A";
		elseif conv_girls_done_choice == 2 then
			conv_girls_done = "conv_girls_done_B";
		else
			conv_girls_done = "conv_girls_done_C";
		end
		
		run_super_conversation(flo, conv_girls_done);
		
		conv_girls_done_choice = conv_girls_done_choice + 1;
		
		if conv_girls_done_choice > 3 then
			conv_girls_done_choice = 1;
		end
		
		game:Set("conv_girls_done_choice", conv_girls_done_choice);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function sprout_on_arrive(flo, sprout)
	flo:FaceActor(sprout);
	flo:StartProc(sprout_conv);
end

function sprout_on_use_inv(item, flo, sprout)

end

sprout1_anim_table =
{
	"anim/girlsprout1/stand",
	"anim/girlsprout1/talk",
};

sprout1_spec = 
{
	name = "GIRL1";
	halo = "quest/objects/girlsprout1";
	anim = sprout1_anim_table;
	
	command = function(actor)
		actor:JumpToNamedPoint("sprout1");
		prepare_actor_text(actor, girlsprout1_text_spec);
		
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		actor:FaceNow(DIR.E);
		
		if game:Get("girl_sprout_money_on_street") == 1 then
			actor:LastingEmotion();
			actor:SetEmotion("sad");
		end
	end;
	
	on_arrive = sprout_on_arrive;
	on_use_inv = sprout_on_use_inv;
};

sprout2_anim_table =
{
	"anim/girlsprout2/stand",
	"anim/girlsprout2/talk",
};

sprout2_spec = 
{
	name = "GIRL2";
	halo = "quest/objects/girlsprout2";
	anim = sprout2_anim_table;
	
	command = function(actor)
		actor:JumpToNamedPoint("sprout2");
		prepare_actor_text(actor, girlsprout2_text_spec);
		
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		actor:FaceNow(DIR.E);
		
		if game:Get("girl_sprout_money_on_street") == 1 then
			actor:LastingEmotion();
			actor:SetEmotion("sad");
		end
	end;
	
	on_arrive = sprout_on_arrive;
	on_use_inv = sprout_on_use_inv;
};

function look_at_box(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_money_box");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

box_spec = 
{
	name = "BOX";
	halo = "box";
	gfx = { image = "money_box_closed" };
	
	command = function(actor)
		actor:SetDepthValue(399);
	end;
	
	on_arrive = function(flo, box)
		--flo:FaceActor(box);
		flo:StartProc(look_at_box);
	end;
}

box_money_spec = 
{
	name = "BOX_MONEY";
	
	command = function(actor)
		actor:SetDepthValue(450);
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		--actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:ModifySaySpec
		{
			--font = "fonts/wiesbadenswing.mvec",
			x = 285,
			y = 300,
			lineheight = 20,
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 1,
			bubble = false,
			fixed = true;
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER,
			w = 70,
			h = 50,
		}
		
		if game:Get("girl_sprout_money_on_street") == 1 then
			-- increment note count
			local note_count = game:Get("note_count");
			
			if note_count < 1 then
				note_count = 0;
			end
			
			actor:SayRaw(note_count*note_value .. ".00");
		end
	end;
}

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_FITNESS:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m2_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function gotosunnysidewest(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_FITNESS:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_west");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_west");
	scene:SetCameraFollowActor(scene.CAMERA);
	
	game:Set("first_time_sproutstand", 1);
	game:SetString("map_position", "m2_cookiestand");
	
	if game:Get("girl_sprout_money_on_street") == 1 then
		run_super_conversation(flo, "conv_girls_reenter_A");
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_sunnysidewest_spec = 
{
	name = "TO_SUNNYSIDEWEST";
	halo = "to_sunnysidewest";
	cursor = "cursor_arrow_w";
	goto_fn = gotosunnysidewest;
}

function gotosunnysideeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	game:SetString("map_position", "m2_fitness");
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_east");
	scene:SetCameraFollowActor(scene.CAMERA);
	spawn_nav_arrow(to_fitness_spec);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_sunnysideeast_spec = 
{
	name = "TO_SUNNYSIDEEAST";
	halo = "to_sunnysideeast";
	cursor = "cursor_arrow_e";
	goto_fn = gotosunnysideeast;
}

function gotofitness(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("module_progress") < 3 then
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		scene:SetCameraFollowActor(scene.FLO);
		flo:WalkTo("to_fitness");
		--wait_walkto();
		
		goto_scene(flo, "m2_fitness");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

to_fitness_spec = 
{
	name = "TO_FITNESS";
	halo = "to_fitness";
	cursor = "cursor_arrow_n";
	goto_fn = gotofitness;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR:PlayAnim("Open");
			else
				scene.DOOR:PlayAnim("Close");
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m2_sunnyside/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end;
}

function look_at_balloons(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_balloons");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

balloons_spec = 
{
	name = "BALLOONS";
	halo = "balloons";
	--gfx = { image = "to_intersection" };
	
	command = function(actor)
		actor:SetDepthValue(247);
	end;
	
	on_arrive = function(flo, balloons)
		--flo:FaceActor(balloons);
		flo:StartProc(look_at_balloons);
	end;
}

fruit_look_count = 0
function look_at_fruit(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if fruit_look_count == 0 then
		fruit_look_count = 1;
		run_super_conversation(flo, "quip_fruit_A");
	else
		fruit_look_count = 0;
		run_super_conversation(flo, "quip_fruit_B");
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

fruit_spec = 
{
	name = "FRUIT";
	halo = "fruit";
	--gfx = { image = "to_intersection" };
	
	command = function(actor)
		actor:SetDepthValue(385);
	end;
	
	on_arrive = function(flo, fruit)
		--flo:FaceActor(fruit);
		flo:StartProc(look_at_fruit);
	end;
}

function look_at_market(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_market");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

market_spec = 
{
	name = "MARKET";
	halo = "market_entrance";
	--gfx = { image = "to_intersection" };
	
	command = function(actor)
		actor:SetDepthValue(368);
	end;
	
	on_arrive = function(flo, market)
		--flo:FaceActor(market);
		flo:StartProc(look_at_market);
	end;
}

current_note_found = nil;

function note_fly_to_box(flo)
	flo:SetMode(MODE.CUTSCENE);
	-- note flies to box
	scene.BOX:LoadImage("money_box_open");
	current_note_found:SetDepthValue(600);
	current_note_found:WalkToXY(note_spawn_position);
	wait_walkto(current_note_found);
	
	scene.BOX:LoadImage("money_box_closed");
	current_note_found:Expire();
	current_note_found = nil;
	
	-- increment note count
	local note_count = game:Get("note_count");
	local total_notes = table.getn(note_info);
	
	if note_count < 1 then
		note_count = 1;
	else
		note_count = note_count + 1;
	end
	
	scene.BOX_MONEY:SayRaw(note_count*note_value .. ".00");
	
	if note_count == total_notes then
		run_super_conversation(flo, "conv_found_bills");
		game:Set("girl_sprout_money_on_street", 2);
		addInventory(inv_desc_cookies);
		complete_quest("pass_girl_sprouts", false);
		complete_quest("get_cookies", false);
		add_quest("use_cookies");
		scene.BOX_MONEY:SayRaw("");
	end
	
	game:Set("note_count", note_count);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

function spawn_notes(first)
	for i,v in pairs(note_info) do
		if game:Get("found_note_" .. i) < 1 then
			scene:Spawn( get_notes_spec(i, first) );
		end
	end
end

function get_notes_spec(note_num, first)
	return 
	{
		name = "NOTE_" .. note_num;
		halo = "note";
		gfx = { image = note_info[note_num].image };
		
		command = function(actor)
			actor:SetDepthValue(note_info[note_num].depth);
			--actor:SetDepthValue(600);
			actor:JumpToPoint(note_info[note_num].position);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:SetWalkSpeed(note_speed);
			
			if first then
				actor:SetPosition(note_spawn_position);
			end
			
			actor.on_arrive = function(flo, note)
				--flo:FaceActor(note);
				game:Set("found_note_" .. note_num, 1);
				current_note_found = note;
				sfx:PlaySFX("audio/sfx/cookies_dollar");
				flo:StartProc(note_fly_to_box);
			end;
		end;
	}
end

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m2_intersection" then
			actor:JumpToNamedPoint("flo_intersection");
		--[[elseif game:GetLastScene() == "m1_subwayred" then
			actor:JumpToNamedPoint("flo_east");
		else -- pet shop
			actor:JumpToNamedPoint("flo_west");]]--
		end
	end;
};

wind_anim_table = 
{
	"anim/m2_sunnyside/wind1",
	"anim/m2_sunnyside/wind2",
	"anim/m2_sunnyside/wind3",
	"anim/m2_sunnyside/wind4",
	"anim/m2_sunnyside/wind5",
};

wind_spec = 
{
	name = "WIND";
	anim = wind_anim_table;
	
	command = function(actor)
		actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		
		sfx:PlaySFX("audio/sfx/cookies_wind");
		actor:PlayAnim("BlowMoney1");
		wait_anim();
		actor:PlayAnim("BlowMoney2");
		wait_anim();
		
		scene.FLO:PlayAnim("OpenMoneyBoxSurprise");
		
		scene.GIRL1:LastingEmotion();
		scene.GIRL1:SetEmotion("sad");
		scene.GIRL1:PlayAnim("DoStandE_sad");
		
		scene.GIRL2:LastingEmotion();
		scene.GIRL2:SetEmotion("sad");
		scene.GIRL2:PlayAnim("DoStandE_sad");
		
		actor:PlayAnim("BlowMoney3");
		wait_anim();
		actor:PlayAnim("BlowMoney4");
		spawn_notes();
		wait_anim();
		actor:PlayAnim("BlowMoney5");
		wait_anim();
		actor:Expire();
	end;
}

sprout_sign_spec = 
{
	name = "SPROUT_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(399);
		actor:ModifySaySpec
		{
			font = "fonts/bruno_jb_std.mvec",
			color = { a = 1, r = 1, g = 1, b = 0.8 },
			outline_size = 0,
			lineheight = 30,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_sprout_sign");
		actor:StopWalking();
		actor:SetPolygon({x=192,y=225}, {x=282,y=212}, {x=197,y=252}, {x=284,y=238});
		actor:TextToImage(20, 0);
	end;
}

girls_sign_spec = 
{
	name = "GIRLS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(399);
		actor:ModifySaySpec
		{
			font = "fonts/bruno_jb_std.mvec",
			color = { a = 1, r = 1, g = 1, b = 0.8 },
			outline_size = 0,
			lineheight = 30,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_girls_sign");
		actor:StopWalking();
		actor:SetPolygon({x=257,y=213}, {x=358,y=227}, {x=257,y=240}, {x=356,y=252});
		actor:TextToImage(20, 0);
	end;
}

jo_sign_spec = 
{
	name = "JO_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/cantoria_mt_std_extrabold.mvec",
			color = { a = 1, r = 0.4, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 60,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_jo_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1660,y=8}, {x=1763,y=9}, {x=1659,y=54}, {x=1763,y=52});
		actor:TextToImage(10, 0);
	end;
}

fitness_sign_spec = 
{
	name = "FITNESS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/cantoria_mt_std_extrabold.mvec",
			color = { a = 1, r = 0.4, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 40,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_fitness_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1582,y=46}, {x=1839,y=46}, {x=1582,y=77}, {x=1837,y=77});
		actor:TextToImage(10, 0);
	end;
}

sale_sign_spec = 
{
	name = "SALE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(399);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:SetAlpha(1);
		
		actor:Say("text_sale_sign");
		actor:StopWalking();
		actor:SetPolygon({x=195,y=355}, {x=224,y=347}, {x=202,y=368}, {x=229,y=361});
		actor:TextToImage(5, 5);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_sunnysidewest_spec);
		spawn_nav_arrow(to_sunnysideeast_spec);
	
		sfx:SetMusic("audio/music/music_streets2.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m2_intersection";
		fade_scene_up(false, no_fade);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("girl_sprout_money_on_street") == 1 then
			spawn_notes();
		end
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(sprout1_spec);
			scene:Spawn(sprout2_spec);
			scene:Spawn(balloons_spec);
		end
		
		spawn_simple_hotspot("end_of_street", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "firehydrant", 736  },
		{ "car02", 747  },
		{ "car01", 750  },
		{ "mask_bush", 380 },
		
		{ "sproutstand", 398  },
		
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		door_spec,
		
		flo_spec, -- the main actor
		
		fruit_spec,
		market_spec,
		box_spec,
		box_money_spec,
		sprout_sign_spec,
		girls_sign_spec,
		jo_sign_spec,
		fitness_sign_spec,
		sale_sign_spec,
	};
};
